<!-- Step 2: Vehicle Details -->
<div class="w-fit">
    <!-- Vehicle Information Section -->
    <div class="mb-8">
        <div class="flex items-center justify-between mb-6">
            <p class="font-mplus text-xl font-bold">Vehicle Details</p>
            <button 
                @click="addVehicle()"
                :disabled="model.vehicles.length >= 5"
                class="text-sm px-4 py-2 bg-orange-600 text-white rounded-lg hover:bg-blue-600 disabled:bg-gray-300 disabled:cursor-not-allowed transition-colors"
            >
                + Add Vehicle
            </button>
        </div>

        <template x-for="(vehicle, index) in model.vehicles" :key="vehicle.id">
            <div class="mb-8 p-6 border border-dashed border-gray-300 rounded-2xl">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="font-semibold text-lg">Vehicle <span x-text="index + 1"></span></h3>
                    <button 
                        @click="removeVehicle(vehicle.id)"
                        :disabled="model.vehicles.length <= 1"
                        class="text-sm px-3 py-1 text-red-600 hover:text-red-800 disabled:text-gray-400 disabled:cursor-not-allowed transition-colors"
                    >
                        Remove
                    </button>
                </div>

                <!-- Vehicle Year -->
                <div class="mb-4">
                    <label class="block font-medium mb-2">Vehicle Year</label>
                    <div 
                        x-data="select2" 
                        x-init="
                            options = yearOptions || []; 
                            selected = (options || []).find(opt => opt.value === vehicle.year) || null;
                            $watch('yearOptions', (newOptions) => { 
                                options = newOptions || []; 
                                selected = (options || []).find(opt => opt.value === vehicle.year) || selected;
                            });
                            $watch('vehicle.year', (newValue) => { 
                                selected = newValue ? options.find(opt => opt.value === newValue) || null : null;
                            });
                        "
                        @select="handleYearSelect($event, vehicle.id)"
                        class="relative"
                    >
                        <!-- Select2 Trigger -->
                        <div 
                            @click="toggle()"
                            class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-transparent cursor-pointer flex items-center justify-between border-gray-200"
                        >
                            <span x-text="selected ? selected.label : 'Select Vehicle Year'" class="text-gray-700"></span>
                            <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </div>

                        <!-- Select2 Dropdown -->
                        <div 
                            x-show="open"
                            @click.away="close()"
                            x-transition:enter="transition ease-out duration-100"
                            x-transition:enter-start="transform opacity-0 scale-95"
                            x-transition:enter-end="transform opacity-100 scale-100"
                            x-transition:leave="transition ease-in duration-75"
                            x-transition:leave-start="transform opacity-100 scale-100"
                            x-transition:leave-end="transform opacity-0 scale-95"
                            class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md text-base ring-1 ring-black ring-opacity-5 focus:outline-none flex flex-col"
                        >
                            <!-- Search Input - Sticky at top -->
                            <div class="px-3 py-2 border-b border-gray-200 bg-white sticky top-0 z-10">
                                <input 
                                    x-ref="search"
                                    x-model="search"
                                    type="text"
                                    placeholder="Search years..."
                                    class="w-full px-2 py-1 text-sm border border-gray-300 rounded focus:outline-none focus:ring-1 focus:ring-orange-500"
                                />
                            </div>
                            
                            <!-- Scrollable Options Container -->
                            <div class="overflow-auto flex-1">
                                <!-- Options -->
                                <template x-for="option in filteredOptions" :key="option.value">
                                    <div 
                                        @click="select(option)"
                                        class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-orange-50 hover:text-orange-900"
                                        :class="selected && selected.value === option.value ? 'bg-orange-100 text-orange-900' : 'text-gray-900'"
                                    >
                                        <span x-text="option.label" class="block truncate"></span>
                                        <span 
                                            x-show="selected && selected.value === option.value"
                                            class="absolute inset-y-0 right-0 flex items-center pr-4"
                                        >
                                            <svg class="h-5 w-5 text-orange-600" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                            </svg>
                                        </span>
                                    </div>
                                </template>
                                
                                <!-- No Results -->
                                <div x-show="filteredOptions.length === 0" class="px-3 py-2 text-sm text-gray-500">
                                    No years found
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Vehicle Make -->
                <div class="mb-4">
                    <label class="block font-medium mb-2">Vehicle Make</label>
                    <div 
                        x-data="select2" 
                        x-init="
                            const vehicleId = vehicle.id;
                            options = (vehicleOptions[vehicleId] && vehicleOptions[vehicleId].makes) || []; 
                            selected = (options || []).find(opt => opt.value === vehicle.make) || null;
                            $watch('vehicleOptions', () => {
                                options = (vehicleOptions[vehicleId] && vehicleOptions[vehicleId].makes) || [];
                                selected = (options || []).find(opt => opt.value === vehicle.make) || selected;
                            }, { deep: true });
                            $watch('vehicle.make', (newValue) => { 
                                selected = newValue ? options.find(opt => opt.value === newValue) || null : null;
                            });
                        "
                        @select="handleMakeSelect($event, vehicle.id)"
                        class="relative"
                    >
                        <!-- Select2 Trigger -->
                        <div 
                            @click="toggle()"
                            :disabled="!vehicle.year"
                            :class="!vehicle.year ? 'border-gray-200 bg-gray-100 cursor-not-allowed' : 'border-gray-200'"
                            class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-transparent cursor-pointer flex items-center justify-between"
                        >
                            <span x-text="selected ? selected.label : (!vehicle.year ? 'Select Year First' : 'Select Make')" class="text-gray-700"></span>
                            <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </div>

                        <!-- Select2 Dropdown -->
                        <div 
                            x-show="open"
                            @click.away="close()"
                            x-transition:enter="transition ease-out duration-100"
                            x-transition:enter-start="transform opacity-0 scale-95"
                            x-transition:enter-end="transform opacity-100 scale-100"
                            x-transition:leave="transition ease-in duration-75"
                            x-transition:leave-start="transform opacity-100 scale-100"
                            x-transition:leave-end="transform opacity-0 scale-95"
                            class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md text-base ring-1 ring-black ring-opacity-5 focus:outline-none flex flex-col"
                        >
                            <!-- Search Input - Sticky at top -->
                            <div class="px-3 py-2 border-b border-gray-200 bg-white sticky top-0 z-10">
                                <input 
                                    x-ref="search"
                                    x-model="search"
                                    type="text"
                                    placeholder="Search makes..."
                                    class="w-full px-2 py-1 text-sm border border-gray-300 rounded focus:outline-none focus:ring-1 focus:ring-orange-500"
                                />
                            </div>
                            
                            <!-- Scrollable Options Container -->
                            <div class="overflow-auto flex-1">
                                <!-- Options -->
                                <template x-for="option in filteredOptions" :key="option.value">
                                    <div 
                                        @click="select(option)"
                                        class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-orange-50 hover:text-orange-900"
                                        :class="selected && selected.value === option.value ? 'bg-orange-100 text-orange-900' : 'text-gray-900'"
                                    >
                                        <span x-text="option.label" class="block truncate"></span>
                                        <span 
                                            x-show="selected && selected.value === option.value"
                                            class="absolute inset-y-0 right-0 flex items-center pr-4"
                                        >
                                            <svg class="h-5 w-5 text-orange-600" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                            </svg>
                                        </span>
                                    </div>
                                </template>
                                
                                <!-- No Results -->
                                <div x-show="filteredOptions.length === 0" class="px-3 py-2 text-sm text-gray-500">
                                    No makes found
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Vehicle Model -->
                <div class="mb-4">
                    <label class="block font-medium mb-2">Vehicle Model</label>
                    <div 
                        x-data="select2" 
                        x-init="
                            const vehicleId = vehicle.id;
                            options = (vehicleOptions[vehicleId] && vehicleOptions[vehicleId].models) || []; 
                            selected = (options || []).find(opt => opt.value === vehicle.model) || null;
                            $watch('vehicleOptions', () => {
                                options = (vehicleOptions[vehicleId] && vehicleOptions[vehicleId].models) || [];
                                selected = (options || []).find(opt => opt.value === vehicle.model) || selected;
                            }, { deep: true });
                            $watch('vehicle.model', (newValue) => { 
                                selected = newValue ? options.find(opt => opt.value === newValue) || null : null;
                            });
                        "
                        @select="handleModelSelect($event, vehicle.id)"
                        class="relative"
                    >
                        <!-- Select2 Trigger -->
                        <div 
                            @click="toggle()"
                            :disabled="!vehicle.make"
                            :class="!vehicle.make ? 'border-gray-200 bg-gray-100 cursor-not-allowed' : 'border-gray-200'"
                            class="w-full px-4 py-3 rounded-2xl bg-teal-50 focus:outline-none focus:ring-2 focus:ring-orange-500 focus:border-transparent cursor-pointer flex items-center justify-between"
                        >
                            <span x-text="selected ? selected.label : (!vehicle.make ? 'Select Make First' : 'Select Model')" class="text-gray-700"></span>
                            <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </div>

                        <!-- Select2 Dropdown -->
                        <div 
                            x-show="open"
                            @click.away="close()"
                            x-transition:enter="transition ease-out duration-100"
                            x-transition:enter-start="transform opacity-0 scale-95"
                            x-transition:enter-end="transform opacity-100 scale-100"
                            x-transition:leave="transition ease-in duration-75"
                            x-transition:leave-start="transform opacity-100 scale-100"
                            x-transition:leave-end="transform opacity-0 scale-95"
                            class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md text-base ring-1 ring-black ring-opacity-5 focus:outline-none flex flex-col"
                        >
                            <!-- Search Input - Sticky at top -->
                            <div class="px-3 py-2 border-b border-gray-200 bg-white sticky top-0 z-10">
                                <input 
                                    x-ref="search"
                                    x-model="search"
                                    type="text"
                                    placeholder="Search models..."
                                    class="w-full px-2 py-1 text-sm border border-gray-300 rounded focus:outline-none focus:ring-1 focus:ring-orange-500"
                                />
                            </div>
                            
                            <!-- Scrollable Options Container -->
                            <div class="overflow-auto flex-1">
                                <!-- Options -->
                                <template x-for="option in filteredOptions" :key="option.value">
                                    <div 
                                        @click="select(option)"
                                        class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-orange-50 hover:text-orange-900"
                                        :class="selected && selected.value === option.value ? 'bg-orange-100 text-orange-900' : 'text-gray-900'"
                                    >
                                        <span x-text="option.label" class="block truncate"></span>
                                        <span 
                                            x-show="selected && selected.value === option.value"
                                            class="absolute inset-y-0 right-0 flex items-center pr-4"
                                        >
                                            <svg class="h-5 w-5 text-orange-600" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                            </svg>
                                        </span>
                                    </div>
                                </template>
                                
                                <!-- No Results -->
                                <div x-show="filteredOptions.length === 0" class="px-3 py-2 text-sm text-gray-500">
                                    No models found
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Vehicle Operable Toggle -->
                <div class="mb-6">
                    <label class="block font-medium mb-2">Is the vehicle operable?</label>
                    <div class="flex items-center space-x-3">
                        <span class="text-sm text-gray-700">No</span>
                        <button 
                            type="button"
                            @click="vehicle.operable = !vehicle.operable; save()"
                            :class="vehicle.operable ? 'bg-blue-600' : 'bg-gray-300'"
                            class="relative inline-flex h-6 w-11 items-center rounded-full transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2"
                        >
                            <span 
                                :class="vehicle.operable ? 'translate-x-6' : 'translate-x-1'"
                                class="inline-block h-4 w-4 transform rounded-full bg-white transition duration-200 ease-in-out"
                            ></span>
                        </button>
                        <span class="text-sm text-gray-700">Yes</span>
                    </div>
                </div>
            </div>
        </template>
    </div>
    
    <!-- Navigation Buttons -->
    <div class="flex gap-4 justify-start">
        <!-- Back Button -->
        <button 
            @click="back()"
            class="w-fit outline-button flex items-center gap-3"
        >
            <?php if (isset($component)) { $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e = $component; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('icon-back'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e)): ?>
<?php $component = $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e; ?>
<?php unset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e); ?>
<?php endif; ?>
            Back – Shipping Route
        </button>
        
        <!-- Next Button -->
        <button 
            @click="next()"
            :disabled="busy"
            class="w-fit primary-button flex items-center gap-3 disabled:opacity-50 disabled:cursor-not-allowed"
        >
            <span x-text="busy ? 'Processing...' : 'Next – Contact'"></span>
            <?php if (isset($component)) { $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e = $component; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('icon-next'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['x-show' => '!busy']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e)): ?>
<?php $component = $__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e; ?>
<?php unset($__componentOriginalcd9972c8156dfa6e5fd36675ca7bf5f21b506e2e); ?>
<?php endif; ?>
        </button>
    </div>
</div>
<?php /**PATH /home/otmdev/public_html/coastalautoshipping.otmdev.co/resources/views/quote/steps/_vehicle.blade.php ENDPATH**/ ?>