<div id="table-of-content" class="table-of-content max-lg:border-2 max-lg:border-blue-50 max-lg:rounded-2xl max-lg:p-5">
    <button id="toc-toggle" class="toc flex lg:hidden items-center justify-between w-full h3 !my-0">Article Overview
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" class="inline-block ml-auto" viewBox="0 0 24 25" fill="none">
            <path d="M19.5 8.75L12 16.25L4.5 8.75" stroke="#03162A" stroke-width="1.5" stroke-linecap="square" stroke-linejoin="round"/>
        </svg>
    </button>
    <p class="h3 max-lg:hidden !my-0">Article Overview</p>
    <ul class="toc-wrap space-y-4 font-semibold mt-5 lg:mt-9 max-lg:hidden"></ul>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        const toc = document.getElementById('table-of-content');
        const article = document.querySelector('article');
        const headings = article.querySelectorAll('h2');
        const tocList = toc.querySelector('ul');
        const h1 = article.querySelector('h1.h2');
        const offset = 120;
        let headingCounter = 1;

        headings.forEach(heading => {
            const id = `head${headingCounter++}`;
            heading.setAttribute('id', id);

            const li = document.createElement('li');
            const a = document.createElement('a');
            a.setAttribute('href', `#${id}`);
            a.textContent = heading.textContent;

            tocList.appendChild(li);
            li.appendChild(a);
        });

        if (tocList.children.length === 0) {
            toc.style.display = 'none';
        }

        toc.querySelectorAll('a').forEach(anchor => {
            anchor.addEventListener('click', function(e) {
                e.preventDefault();
                const targetId = this.getAttribute('href').substring(1);
                const targetElement = document.getElementById(targetId);
                const targetPosition = targetElement.getBoundingClientRect().top + window.scrollY - offset;

                window.scrollTo({
                    top: targetPosition,
                    behavior: 'smooth'
                });
            });
        });
    });
</script>

<?php $__env->startPush('after-scripts'); ?>
    <script>
        (function ($) {
            $(document).ready(function() {
                $("#toc-toggle").click(function() {
                    $(this).siblings(".toc-wrap").slideToggle(300);
                    $(this).toggleClass("active");
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /Users/ihfaz/Sites/coastalautoshipping/resources/views/partials/table-of-contents.blade.php ENDPATH**/ ?>