<?php
    $current_page_id = get_the_ID();

    $args = [
        'post_type' => 'page',
        'post_status' => 'publish',
        'meta_key' => '_wp_page_template',
        'meta_value' => 'page-practice-area.blade.php',
        'post__not_in' => [$current_page_id],
        'orderby' => 'title',
        'order' => 'ASC',
        'posts_per_page' => -1,
    ];

    $practice_area_pages = new WP_Query($args);
?>

<?php if($practice_area_pages->have_posts()): ?>
    <div class="mt-16">
        <p class="h3 mb-7">Other Practice Areas</p>
        <ul class="space-y-4">
            <?php while($practice_area_pages->have_posts()): ?> <?php $practice_area_pages->the_post(); ?>
                <?php if (get_field('pa_icon')) : ?>
                    <li>
                        <a href="<?php echo e(get_permalink()); ?>" class="group flex items-center gap-4 text-xl font-medium p-4 bg-white rounded-2xl border border-oyster200 hover:border-oyster500 transition-all" title="<?php echo e(get_the_title()); ?>">
                            <div class="flex items-center justify-center h-11 w-11 rounded-full group-hover:bg-oyster100 transition-all">
                                <?php echo get_field('pa_icon'); ?>
                            </div>
                            <?php echo get_the_title(); ?>

                        </a>
                    </li>
                <?php endif; ?>
            <?php endwhile; ?>
        </ul>
    </div>
<?php endif; ?>

<?php
    wp_reset_postdata();
?><?php /**PATH /var/www/vhosts/jacobsandjacobs.net/httpdocs/resources/views/sections/practice-area/interlinking.blade.php ENDPATH**/ ?>