<section class="py-16 md:py-20 lg:py-52 bg-navy-100">
    <div class="container grid lg:grid-cols-2 gap-8">
        <?php
            $shipFrom = [
                [
                    'slug' => 'kauai',
                    'label' => 'Kauai',
                    'name' => 'Kauai Port',
                    'address' => [
                        'Nawiliwili Harbor Pier 2',
                        'Lihue, HI 96766',
                    ],
                    'mapUrl' => 'https://maps.app.goo.gl/2M3b1QFPiQJvwUdE8',
                    'hours' => [
                        'weekday' => [
                            ['7:00am', '11:30am'],
                            ['1:00pm', '3:00pm'],
                        ],
                        'note' => '<b style="font-weight: 600;">Wednesday</b><br> 7:00am – 11:30am',
                        'weekend' => 'Closed',
                    ],
                ],
                [
                    'slug' => 'oahu',
                    'label' => 'Oahu',
                    'name' => 'Oahu Port',
                    'address' => [
                        '1411 Sand Island Parkway',
                        'Honolulu, HI 96803',
                    ],
                    'mapUrl' => 'https://maps.app.goo.gl/e5n5gxWGQW97uNaYA',
                    'hours' => [
                        'weekday' => [
                            ['8:00am', '11:30am'],
                            ['1:00pm', '3:00pm'],
                        ],
                        'weekend' => 'Closed',
                    ],
                ],
                [
                    'slug' => 'maui',
                    'label' => 'Maui',
                    'name' => 'Maui Port',
                    'address' => [
                        'Perimeter Road Pier 1',
                        'Kahului, HI 96732',
                    ],
                    'mapUrl' => 'https://maps.app.goo.gl/hwopLU5tDtv2ov7V9',
                    'hours' => [
                        'weekday' => [
                            ['7:00am', '11:30am'],
                            ['1:00pm', '3:00pm'],
                        ],
                        'weekend' => 'Closed',
                    ],
                ],
                [
                    'slug' => 'big-island',
                    'label' => 'Big Island',
                    'name' => 'Big Island Port',
                    'address' => [
                        'Hilo Harbor 55 Kahanu Street',
                        'Hilo, HI 96720',
                    ],
                    'mapUrl' => 'https://maps.app.goo.gl/NhFhMLhVkHL79oSWA',
                    'hours' => [
                        'weekday' => [
                            ['7:30am', '11:30am'],
                            ['1:00pm', '3:00pm'],
                        ],
                        'weekend' => 'Closed',
                    ],
                ],
            ];

            $shipTo = [
                [
                    'slug' => 'tacoma',
                    'label' => 'Tacoma',
                    'name' => 'Tacoma Port',
                    'address' => [
                        '1675 Lincoln Ave Building 300',
                        'Tacoma, WA 98421',
                    ],
                    'mapUrl' => 'https://maps.app.goo.gl/uwCb6yku9gVgbTTj6',
                    'hours' => [
                        'weekday' => [
                            ['8:00am', '11:30am'],
                            ['1:00pm', '3:00pm'],
                        ],
                        'weekend' => 'Closed',
                    ],
                ],
                [
                    'slug' => 'oakland',
                    'label' => 'Oakland',
                    'name' => 'Oakland Port',
                    'address' => [
                        '1579 Middle Harbor Road Berth 63',
                        'Oakland, CA 94607',
                    ],
                    'mapUrl' => 'https://maps.app.goo.gl/Nq7tsV1aTJ53DNmp9',
                    'hours' => [
                        'weekday' => [
                            ['8:00am', '11:30am'],
                            ['1:00pm', '4:00pm'],
                        ],
                        'weekend' => 'Closed',
                    ],
                ],
                [
                    'slug' => 'long-beach',
                    'label' => 'Long Beach',
                    'name' => 'Long Beach Port',
                    'address' => [
                        '1320 Pier C Street',
                        'Long Beach, CA 90813',
                    ],
                    'mapUrl' => 'https://maps.app.goo.gl/rxLikH4EXLHT1isJ6',
                    'hours' => [
                        'weekday' => [
                            ['8:00am', '11:30am'],
                            ['1:00pm', '4:00pm'],
                        ],
                        'weekend' => 'Closed',
                    ],
                ],
            ];
        ?>

        <div
            x-data='{
                from: <?php echo json_encode($shipFrom, 15, 512) ?>,
                to: <?php echo json_encode($shipTo, 15, 512) ?>,
                selectedGroup: "from",
                selectedSlug: <?php echo json_encode($shipFrom[0]["slug"], 15, 512) ?>,
                get items() { return this[this.selectedGroup]; },
                get current() { return this.items.find(i => i.slug === this.selectedSlug) || null; },
                select(group, slug) { this.selectedGroup = group; this.selectedSlug = slug; this.open = true; },
                open: true,
                close() { this.open = false; }
            }'
            class="relative"
        >
        <h2 class="lg:text-4xl mb-8 lg:mb-14">Trusted Hawaii Shipping Services</h2>
            <div class="space-y-6">
                <div>
                    <h3 class="text-navy-900 text-xl font-semibold">Ship from</h3>
                    <div class="mt-4 flex flex-wrap gap-3">
                        <?php $__currentLoopData = $shipFrom; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button
                                type="button"
                                @click="select('from', '<?php echo e($item['slug']); ?>')"
                                :class="{
                                    'bg-orange-600 text-white': selectedGroup==='from' && selectedSlug==='<?php echo e($item['slug']); ?>',
                                    'bg-white text-navy-800': !(selectedGroup==='from' && selectedSlug==='<?php echo e($item['slug']); ?>')
                                }"
                                class="px-5 py-2 rounded-2xl transition-all"
                            >
                                <?php echo e($item['label']); ?>

                            </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <div>
                    <h3 class="text-navy-900 text-xl font-semibold">Ship to</h3>
                    <div class="mt-4 flex flex-wrap gap-3">
                        <?php $__currentLoopData = $shipTo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button
                                type="button"
                                @click="select('to', '<?php echo e($item['slug']); ?>')"
                                :class="{
                                    'bg-orange-600 text-white': selectedGroup==='to' && selectedSlug==='<?php echo e($item['slug']); ?>',
                                    'bg-white text-navy-800': !(selectedGroup==='to' && selectedSlug==='<?php echo e($item['slug']); ?>')
                                }"
                                class="px-5 py-2 rounded-2xl transition-all"
                            >
                                <?php echo e($item['label']); ?>

                            </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <p class="mt-2">and vice versa</p>
                </div>
            </div>

            <div class="mt-8 lg:mt-14">
                <div
                    x-show="open && current"
                    x-transition:enter="transition ease-out duration-300"
                    x-transition:enter-start="opacity-0 translate-y-2 scale-[0.98]"
                    x-transition:enter-end="opacity-100 translate-y-0 scale-100"
                    x-transition:leave="transition ease-in duration-200"
                    x-transition:leave-start="opacity-100 translate-y-0 scale-100"
                    x-transition:leave-end="opacity-0 translate-y-2 scale-[0.98]"
                    class="relative rounded-[32px] bg-white p-6 lg:p-10"
                >
                    <p class="text-2xl font-bold font-mplus text-navy-900 mb-5 lg:mb-8" x-text="current?.name"></p>
                    <button
                        type="button"
                        class="absolute right-4 top-4 inline-flex h-9 w-9 items-center justify-center rounded-full hover:text-navy-900 hover:bg-navy-50 focus:outline-none"
                        @click="close()"
                        aria-label="Close"
                    >
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                        <path d="M14.6597 13.4655C14.8182 13.624 14.9072 13.839 14.9072 14.0631C14.9072 14.2873 14.8182 14.5023 14.6597 14.6608C14.5012 14.8193 14.2862 14.9084 14.062 14.9084C13.8378 14.9084 13.6229 14.8193 13.4644 14.6608L9.00021 10.1953L4.53467 14.6594C4.37616 14.8179 4.16118 14.907 3.93701 14.907C3.71285 14.907 3.49786 14.8179 3.33935 14.6594C3.18085 14.5009 3.0918 14.2859 3.0918 14.0617C3.0918 13.8376 3.18085 13.6226 3.33935 13.4641L7.8049 8.99994L3.34076 4.53439C3.18225 4.37588 3.0932 4.1609 3.0932 3.93674C3.0932 3.71257 3.18225 3.49759 3.34076 3.33908C3.49927 3.18057 3.71425 3.09152 3.93842 3.09152C4.16258 3.09152 4.37756 3.18057 4.53607 3.33908L9.00021 7.80463L13.4658 3.33838C13.6243 3.17987 13.8393 3.09082 14.0634 3.09082C14.2876 3.09082 14.5026 3.17987 14.6611 3.33838C14.8196 3.49689 14.9086 3.71187 14.9086 3.93603C14.9086 4.1602 14.8196 4.37518 14.6611 4.53369L10.1955 8.99994L14.6597 13.4655Z" fill="#64748B"/>
                      </svg>
                    </button>
                    <div class="grid gap-8 md:grid-cols-2">
                        <div>
                            <div>
                                <div class="font-semibold">Address</div>
                                <div class="mt-3 text-navy-800 space-y-1">
                                    <template x-for="line in current?.address" :key="line">
                                        <p x-text="line"></p>
                                    </template>
                                </div>
                                <a
                                    class="inline-block text-blue-600 hover:text-orange-600 font-semibold mt-1"
                                    :href="current?.mapUrl"
                                    target="_blank" rel="nofollow noopener"
                                >
                                    Get Directions
                                </a>
                            </div>
                        </div>

                        <div>
                            <div class="font-semibold">Drop-off &amp; Pick-up Hours</div>
                            <div class="mt-3 flex gap-3 text-navy-900">
                                <div>
                                    <div class="font-semibold">Monday – Friday</div>
                                    <template x-if="Array.isArray(current?.hours?.weekday)">
                                        <div class="space-y-1 text-navy-700">
                                            <template x-for="(range, idx) in current.hours.weekday" :key="idx">
                                                <div>
                                                    <span x-text="range[0]"></span>
                                                    <span class="mx-1">–</span>
                                                    <span x-text="range[1]"></span>
                                                </div>
                                            </template>
                                            <template x-if="current?.hours?.note">
                                                <div x-html="current.hours.note"></div>
                                            </template>
                                        </div>
                                    </template>
                                </div>
                                <div>
                                    <div class="font-semibold">Weekends</div>
                                    <div class="mt-1 text-navy-700" x-text="current?.hours?.weekend"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="max-lg:hidden">
            <img src="<?= \Roots\asset('images/content/hawaii-map.svg'); ?>" alt="Hawaii Map" class="w-full">
        </div>
    </div>
</section><?php /**PATH /home/otmdev/public_html/coastalautoshipping.otmdev.co/resources/views/sections/services/hawaii-car/shipping-locations.blade.php ENDPATH**/ ?>