<section class="bg-oyster100 pb-10 lg:pb-24">
    <div class="container">
        <div class="max-lg:flex max-lg:flex-col-reverse lg:grid lg:grid-cols-2 gap-8 lg:items-center">
            <div class="xl:pr-14">
                <h2 class="h1 mb-5 lg:mb-12">Experienced Trial Attorney with a Passion for Justice</h2>
                <div class="space-y-7">
                    <?php the_content(); ?>
                </div>
            </div>
            <div>
                <?php if(has_post_thumbnail()): ?>
                    <img src="<?php echo e(get_the_post_thumbnail_url()); ?>" class="max-md:max-h-[400px] max-lg:max-h-[600px] shrink-0 rounded-2xl overflow-hidden object-cover object-center max-[450px]:w-full" alt="<?php echo $heading; ?> Headshot" title="<?php echo $heading; ?>" loading="lazy">
                <?php else: ?>
                    <img src="<?= \Roots\asset('images/backgrounds/attorney-placeholder.svg'); ?>" alt="Image Placeholder" title="Image Coming Soon" class="object-cover object-top md:object-center w-full" loading="lazy">
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<div class="bg-oyster100 pb-20 lg:pb-40">
    <div class="container">
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 lg:gap-8 items-start">
            <div class="flex items-center justify-center bg-white rounded-2xl border border-oyster200 h-35 md:h-40 lg:h-56 overflow-hidden">
                <picture>
                    <source srcset="<?= \Roots\asset('images/wsaj.webp'); ?>" type="image/webp">
                    <source srcset="<?= \Roots\asset('images/wsaj.png'); ?>" type="image/png">
                    <img src="<?= \Roots\asset('images/wsaj.png'); ?>" class="shrink-0 max-h-21.25 md:max-h-25 lg:max-h-[126px]" alt="Badge - WSAJ Eagle 2022" title="WSAJ Eagle 2022" loading="lazy">
                </picture>
            </div>
            <div class="flex items-center justify-center bg-white rounded-2xl border border-oyster200 h-35 md:h-40 lg:h-56 overflow-hidden">
                <picture>
                    <source srcset="<?= \Roots\asset('images/avvo.webp'); ?>" type="image/webp">
                    <source srcset="<?= \Roots\asset('images/avvo.png'); ?>" type="image/png">
                    <img src="<?= \Roots\asset('images/avvo.png'); ?>" class="shrink-0 max-h-21.25 md:max-h-25 lg:max-h-[126px]" alt="Badge - AVVO Rating" title="AVVO Rating 10.0" loading="lazy">
                </picture>
            </div>
            <div class="flex items-center justify-center bg-white rounded-2xl border border-oyster200 h-35 md:h-40 lg:h-56 overflow-hidden">
                <picture>
                    <source srcset="<?= \Roots\asset('images/ntl.webp'); ?>" type="image/webp">
                    <source srcset="<?= \Roots\asset('images/ntl.png'); ?>" type="image/png">
                    <img src="<?= \Roots\asset('images/ntl.png'); ?>" class="shrink-0 max-h-21.25 md:max-h-25 lg:max-h-[126px]" alt="Badge - The National Trial Lawyers" title="The National Trial Lawyers Top 100" loading="lazy">
                </picture>
            </div>
            <div class="flex items-center justify-center bg-white rounded-2xl border border-oyster200 h-35 md:h-40 lg:h-56 overflow-hidden">
                <picture>
                    <source srcset="<?= \Roots\asset('images/google.webp'); ?>" type="image/webp">
                    <source srcset="<?= \Roots\asset('images/google.png'); ?>" type="image/png">
                    <img src="<?= \Roots\asset('images/google.png'); ?>" class="shrink-0 max-h-10.75 md:max-h-15.5" alt="Badge - Google Reviews" title="Google Reviews - 5.0" loading="lazy">
                </picture>
            </div>
        </div>
    </div>
</div><?php /**PATH /Users/ihfaz/Sites/jacobsandjacobs/resources/views/sections/attorney/content.blade.php ENDPATH**/ ?>