<!doctype html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="theme-color" content="#F0EEE3" media="(prefers-color-scheme: light)">
        <meta name="theme-color" content="#555247" media="(prefers-color-scheme: dark)">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&family=M+PLUS+1:wght@100..900&display=swap" rel="stylesheet">
        
        <?php wp_head(); ?>
        <?php echo $__env->make('utils.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </head>

    <body <?php body_class('px-0 overflow-x-hidden'); ?>>
        <?php wp_body_open(); ?>
        <?php do_action('get_header'); ?>
        <div id="app">

            <?php echo $__env->make('sections.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->yieldContent('before-content'); ?>

            <div class="<?php echo e($containerInnerClasses); ?> <?php if (! empty(trim($__env->yieldContent('sidebar')))): ?> gap-6 lg:grid-cols-12 grid <?php endif; ?>">
                <main id="main" class="<?php if (! empty(trim($__env->yieldContent('sidebar')))): ?>lg:col-span-8 <?php endif; ?>">
                    <div>
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </main>

                <?php if (! empty(trim($__env->yieldContent('sidebar')))): ?>
                    <aside class="sidebar lg:col-span-4">
                        <?php echo $__env->yieldContent('sidebar'); ?>
                    </aside>
                <?php endif; ?>
            </div>

            <?php echo $__env->yieldContent('after-content'); ?>

            <?php echo $__env->make('sections.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <?php do_action('get_footer'); ?>
        <?php echo $__env->yieldPushContent('after-scripts'); ?>
        <?php wp_footer(); ?>
        <?php echo $__env->make('utils.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </body>
</html><?php /**PATH /Users/ihfaz/Sites/coastalautoshipping/resources/views/layouts/app.blade.php ENDPATH**/ ?>