<section class="pt-10 lg:pt-20 pb-16 lg:pb-36">
	<?php if(function_exists('rank_math_the_breadcrumbs')): ?>
		<div class="container mb-5 lg:mb-12">
			<?php rank_math_the_breadcrumbs(); ?>
		</div>
	<?php endif; ?>
    <div class="container grid lg:grid-cols-2 xl:grid-cols-[1fr_500px] gap-10 lg:gap-15 xl:gap-35">
        <div>
            <h1 class="h2 mb-6"><?php echo $heading; ?></h1>
            <p class="mb-5">Our friendly customer service representatives are committed to answering all your questions and meeting any need you may have. We would love to hear from you!</p>
			<p class="font-semibold">Please fill out the form so we may assist you.</p>
			<div class="p-10 border-2 border-blue-50 rounded-[32px] mt-8 bg-light-gradient-top max-lg:hidden">
				<p class="h3">Prefer to talk?</p>
				<p class="my-5">Call us now at <a href="tel:<?php echo get_field('contact_information', 'option')['phone_number']; ?>" class="hover:text-orange-600 transition-all" title="Call Us"><?php echo get_field('contact_information', 'option')['phone_number']; ?></a> for instant assistance! Our experts are ready to help you with fast, reliable answers.</p>
				<a href="tel:<?php echo get_field('contact_information', 'option')['phone_number']; ?>" class="flex items-center w-fit gap-1.5 py-3 px-5 border-2 hover:text-white hover:bg-orange-600 border-orange-600 rounded-2xl font-semibold text-navy-950 group flex-shrink-0 transition-all" title="Call Us">
					<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none" class="group-hover:animate-phone-wiggle origin-center">
						<path d="M18.1156 13.6781C17.9763 14.7367 17.4564 15.7085 16.6531 16.4118C15.8497 17.1151 14.8177 17.5019 13.75 17.5C7.54688 17.5 2.50001 12.4531 2.50001 6.25C2.49809 5.18226 2.88492 4.15033 3.58824 3.34695C4.29155 2.54357 5.26326 2.02368 6.32188 1.88438C6.58958 1.85169 6.86067 1.90646 7.09468 2.0405C7.3287 2.17455 7.51309 2.38068 7.62032 2.62813L9.27032 6.31172V6.3211C9.35242 6.51051 9.38633 6.71731 9.36901 6.92303C9.3517 7.12875 9.2837 7.32697 9.1711 7.5C9.15704 7.5211 9.14219 7.54063 9.12657 7.56016L7.50001 9.48828C8.08516 10.6773 9.32891 11.9102 10.5336 12.4969L12.4352 10.8789C12.4538 10.8632 12.4734 10.8486 12.4938 10.8352C12.6666 10.7198 12.8655 10.6495 13.0725 10.6304C13.2794 10.6113 13.4878 10.6441 13.6789 10.7258L13.6891 10.7305L17.3695 12.3797C17.6174 12.4865 17.8241 12.6708 17.9585 12.9048C18.093 13.1389 18.1481 13.4102 18.1156 13.6781Z" fill="currentColor"/>
					</svg>
					<span><?php echo get_field('contact_information', 'option')['phone_number']; ?></span>
				</a>
				<p class="text-lg font-semibold mt-3">Se Habla Español</p>
			</div>
        </div>
		<div>
			<p class="h3 mb-1">We're Ready to Help</p>
			<p class="mb-8">Our team will assist you as soon as possible.</p>
			<div>
				<?php echo do_shortcode('[contact-form-7 id="e324439"]'); ?>
			</div>
		</div>
		<div class="p-10 border-2 border-blue-50 rounded-[32px] bg-light-gradient-top lg:hidden">
			<p class="h3">Prefer to talk?</p>
			<p class="my-5">Call us now at <a href="tel:<?php echo get_field('contact_information', 'option')['phone_number']; ?>" class="hover:text-orange-600 transition-all" title="Call Us"><?php echo get_field('contact_information', 'option')['phone_number']; ?></a> for instant assistance! Our experts are ready to help you with fast, reliable answers.</p>
			<a href="tel:<?php echo get_field('contact_information', 'option')['phone_number']; ?>" class="flex items-center w-fit gap-1.5 py-3 px-5 border-2 hover:text-white hover:bg-orange-600 border-orange-600 rounded-2xl font-semibold text-navy-950 group flex-shrink-0 transition-all" title="Call Us">
				<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none" class="group-hover:animate-phone-wiggle origin-center">
					<path d="M18.1156 13.6781C17.9763 14.7367 17.4564 15.7085 16.6531 16.4118C15.8497 17.1151 14.8177 17.5019 13.75 17.5C7.54688 17.5 2.50001 12.4531 2.50001 6.25C2.49809 5.18226 2.88492 4.15033 3.58824 3.34695C4.29155 2.54357 5.26326 2.02368 6.32188 1.88438C6.58958 1.85169 6.86067 1.90646 7.09468 2.0405C7.3287 2.17455 7.51309 2.38068 7.62032 2.62813L9.27032 6.31172V6.3211C9.35242 6.51051 9.38633 6.71731 9.36901 6.92303C9.3517 7.12875 9.2837 7.32697 9.1711 7.5C9.15704 7.5211 9.14219 7.54063 9.12657 7.56016L7.50001 9.48828C8.08516 10.6773 9.32891 11.9102 10.5336 12.4969L12.4352 10.8789C12.4538 10.8632 12.4734 10.8486 12.4938 10.8352C12.6666 10.7198 12.8655 10.6495 13.0725 10.6304C13.2794 10.6113 13.4878 10.6441 13.6789 10.7258L13.6891 10.7305L17.3695 12.3797C17.6174 12.4865 17.8241 12.6708 17.9585 12.9048C18.093 13.1389 18.1481 13.4102 18.1156 13.6781Z" fill="currentColor"/>
				</svg>
				<span><?php echo get_field('contact_information', 'option')['phone_number']; ?></span>
			</a>
			<p class="text-lg font-semibold mt-3">Se Habla Español</p>
		</div>
    </div>
</section>
<section>
	<div class="container">
		<h2 class="mb-10 lg:mb-14">Our Locations</h2>
		<div class="grid md:grid-cols-2 gap-10">
			<?php if (have_rows('office_locations', 'option')) : ?><?php while (have_rows('office_locations', 'option')) : the_row(); ?>
				<div class="grid gap-7">
					<div class="grid grid-cols-[24px_1fr] gap-4">
						<svg xmlns="http://www.w3.org/2000/svg" class="mt-0.5" width="24" height="24" viewBox="0 0 24 24" fill="none">
							<path d="M12 1.5C9.81273 1.50248 7.71575 2.37247 6.16911 3.91911C4.62247 5.46575 3.75248 7.56273 3.75 9.75C3.75 16.8094 11.25 22.1409 11.5697 22.3641C11.6958 22.4524 11.846 22.4998 12 22.4998C12.154 22.4998 12.3042 22.4524 12.4303 22.3641C12.75 22.1409 20.25 16.8094 20.25 9.75C20.2475 7.56273 19.3775 5.46575 17.8309 3.91911C16.2843 2.37247 14.1873 1.50248 12 1.5ZM12 6.75C12.5933 6.75 13.1734 6.92595 13.6667 7.25559C14.1601 7.58524 14.5446 8.05377 14.7716 8.60195C14.9987 9.15013 15.0581 9.75333 14.9424 10.3353C14.8266 10.9172 14.5409 11.4518 14.1213 11.8713C13.7018 12.2909 13.1672 12.5766 12.5853 12.6924C12.0033 12.8081 11.4001 12.7487 10.8519 12.5216C10.3038 12.2946 9.83524 11.9101 9.50559 11.4167C9.17595 10.9234 9 10.3433 9 9.75C9 8.95435 9.31607 8.19129 9.87868 7.62868C10.4413 7.06607 11.2044 6.75 12 6.75Z" fill="#4668C4"/>
						</svg>
						<?php if(get_sub_field('address_line_1')): ?>
						<div>
							<p class="text-xl font-semibold mb-2"><?php echo get_sub_field('location_name'); ?></p>
							<a href="<?php echo get_sub_field('address_url'); ?>" class="hover:text-orange-600 transition-all" target="_blank" title="Visit Our <?php echo get_sub_field('location_name'); ?>">
								<?php echo get_sub_field('address_line_1'); ?><br> <?php echo get_sub_field('address_line_2'); ?>
							</a>
						</div>
						<?php endif; ?>
					</div>
					<div>
						<iframe class="bg-blue-50 h-[300px]" src="<?php echo get_sub_field('map_url'); ?>" width="100%" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
					</div>
				</div>
			<?php endwhile; endif; ?>
		</div>
	</div>
</section><?php /**PATH /home/otmdev/public_html/coastalautoshipping.otmdev.co/resources/views/sections/contact-us/contact-info.blade.php ENDPATH**/ ?>