// https://tailwindcss.com/docs/configuration
import type { Config } from 'tailwindcss';
import forms from '@tailwindcss/forms';

export default {
  content: [
    './app/**/*.php',
    './resources/**/*.{php,js,ts,tsx,vue}',
    './resources/views/**/*.php',
    './public/content/themes/radicle/index.php',
  ],
  theme: {
    screens: {
      'sm': '640px',
      'md': '768px',
      'lg': '992px',
      'xl': '1280px',
    },
    fontFamily: {
      sans: ['"DM Sans"', "sans-serif"],
      'dmsans': ['"DM Sans"', "sans-serif"],
      'mplus': ['"M PLUS 1"', "serif"],
    },
    extend: {
      container: {
        center: true,
        padding: '16px',
      },
      transitionDuration: {
        DEFAULT: '300ms',
      },
      fontSize: {
        '12px': '0.75rem',
        '14px': '0.875rem',
        '16px': '1rem',
        '18px': '1.125rem',
        '20px': '1.25rem',
        '22px': '1.375rem',
        '24px': '1.5rem',
        '26px': '1.625rem',
        '28px': '1.75rem',
        '30px': '1.875rem',
        '32px': '2rem',
        '34px': '2.125rem',
        '36px': '2.25rem',
        '39px': '2.4375rem',
        '40px': '2.5rem',
        '42px': '2.625rem',
        '44px': '2.75rem',
        '46px': '2.875rem',
        '50px': '3.125rem',
        '52px': '3.25rem',
        '58px': '3.625rem',
        '64px': '4rem',
        '70px': '4.37rem',
        '73px': '4.56rem',
        '110px': '6.875rem',
        '130px': '8.125rem',
      },
      lineHeight: {
        '110': '1.1',
        '120': '1.2',
        '130': '1.3',
        '140': '1.4',
        '150': '1.5',
        '160': '1.6',
      },
      maxWidth: {
        '437': '437px',
        '550': '550px',
        '665': '665px',
        '778': '778px',
      },
      minWidth: {
        '235': '235px',
      },
      spacing: {
        '0.25': '1px',
        '0.5': '2px',
        '0.75': '3px',
        '1': '4px',
        '1.25': '5px',
        '1.5': '6px',
        '1.75': '7px',
        '2': '8px',
        '2.25': '9px',
        '2.5': '10px',
        '2.75': '11px',
        '3': '12px',
        '3.25': '13px',
        '3.5': '14px',
        '3.75': '15px',
        '4': '16px',
        '4.25': '17px',
        '4.5': '18px',
        '4.75': '19px',
        '5': '20px',
        '5.25': '21px',
        '5.5': '22px',
        '5.75': '23px',
        '6': '24px',
        '6.25': '25px',
        '6.5': '26px',
        '6.75': '27px',
        '7': '28px',
        '7.25': '29px',
        '7.5': '30px',
        '7.75': '31px',
        '8': '32px',
        '8.25': '33px',
        '8.5': '34px',
        '8.75': '35px',
        '9': '36px',
        '9.25': '37px',
        '9.5': '38px',
        '9.75': '39px',
        '10': '40px',
        '10.25': '41px',
        '10.5': '42px',
        '10.75': '43px',
        '11': '44px',
        '11.25': '45px',
        '11.5': '46px',
        '11.75': '47px',
        '12': '48px',
        '12.25': '49px',
        '12.5': '50px',
        '12.75': '52px',
        '13': '52px',
        '13.25': '53px',
        '13.5': '54px',
        '13.75': '55px',
        '14': '56px',
        '14.25': '57px',
        '14.5': '58px',
        '14.75': '59px',
        '15': '60px',
        '15.25': '61px',
        '15.5': '62px',
        '15.75': '63px',
        '16': '64px',
        '16.25': '65px',
        '16.5': '66px',
        '16.75': '67px',
        '17': '68px',
        '17.25': '69px',
        '17.5': '70px',
        '17.75': '71px',
        '18': '72px',
        '18.25': '73px',
        '18.5': '74px',
        '18.75': '75px',
        '19': '76px',
        '19.25': '77px',
        '19.5': '78px',
        '19.75': '79px',
        '20': '80px',
        '20.25': '81px',
        '20.5': '82px',
        '20.75': '83px',
        '21': '84px',
        '21.25': '85px',
        '21.5': '86px',
        '21.75': '87px',
        '22': '88px',
        '22.25': '89px',
        '22.5': '90px',
        '22.75': '91px',
        '23': '92px',
        '23.25': '93px',
        '23.5': '94px',
        '23.75': '95px',
        '24': '96px',
        '24.25': '97px',
        '24.5': '98px',
        '24.75': '99px',
        '25': '100px',
        '25.25': '101px',
        '25.5': '102px',
        '25.75': '103px',
        '26': '104px',
        '26.25': '105px',
        '26.5': '106px',
        '26.75': '107px',
        '27': '108px',
        '27.25': '109px',
        '27.5': '110px',
        '27.75': '111px',
        '28': '112px',
        '30': '120px',
        '31': '124px',
        '35': '140px',
        '37.5': '150px',
        '40': '160px',
        '67.5': '270px',
        '75': '300px',
        '81.5': '326px',
        '90': '360px',
      },
      colors: {
        'inherit': 'inherit',
        'current': 'currentColor',
        'transparent': 'transparent',
        'white': '#FFFFFF',
        'orange': {
          '600': '#DB7A43',
        },
        'blue': {
          '600': '#4668C4',
          '50': '#F0F3F9',
        },
        'teal': {
          '50': '#F6FCFF',
        },
        'navy': {
          '950': '#03162A',
          '800': '#042546',
          '700': '#002C57',
          '200': '#E0E8F8',
          '100': '#F2F5FB',
        },
        'gray': {
          '600': '#3C5166',
          '500': '#64748B',
          '300': '#D1D5DB',
          '200': '#EAECF0',
        },
      },
      scale: {
        '1000': '10',
        '1500': '15',
        '2000': '20',
      },
      listStyleImage: {
        'check': "url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='25' viewBox='0 0 24 32' fill='none'%3E%3Cg transform='translate(0 10)'%3E%3Cpath d='M12 2.89844C10.0716 2.89844 8.18657 3.47027 6.58319 4.54161C4.97982 5.61295 3.73013 7.13569 2.99218 8.91727C2.25422 10.6989 2.06114 12.6593 2.43735 14.5506C2.81355 16.4419 3.74215 18.1792 5.10571 19.5427C6.46928 20.9063 8.20656 21.8349 10.0979 22.2111C11.9892 22.5873 13.9496 22.3942 15.7312 21.6563C17.5127 20.9183 19.0355 19.6686 20.1068 18.0652C21.1782 16.4619 21.75 14.5768 21.75 12.6484C21.7473 10.0634 20.7192 7.58505 18.8913 5.75716C17.0634 3.92927 14.585 2.90117 12 2.89844ZM16.2806 10.9291L11.0306 16.1791C10.961 16.2488 10.8783 16.3041 10.7872 16.3419C10.6962 16.3796 10.5986 16.399 10.5 16.399C10.4014 16.399 10.3038 16.3796 10.2128 16.3419C10.1218 16.3041 10.039 16.2488 9.96938 16.1791L7.71938 13.9291C7.57865 13.7883 7.49959 13.5975 7.49959 13.3984C7.49959 13.1994 7.57865 13.0085 7.71938 12.8678C7.86011 12.7271 8.05098 12.648 8.25 12.648C8.44903 12.648 8.6399 12.7271 8.78063 12.8678L10.5 14.5881L15.2194 9.86781C15.2891 9.79813 15.3718 9.74285 15.4628 9.70514C15.5539 9.66743 15.6515 9.64802 15.75 9.64802C15.8486 9.64802 15.9461 9.66743 16.0372 9.70514C16.1282 9.74285 16.2109 9.79813 16.2806 9.86781C16.3503 9.93749 16.4056 10.0202 16.4433 10.1113C16.481 10.2023 16.5004 10.2999 16.5004 10.3984C16.5004 10.497 16.481 10.5946 16.4433 10.6856C16.4056 10.7767 16.3503 10.8594 16.2806 10.9291Z' fill='%23DB7A43'/%3E%3C/g%3E%3C/svg%3E\")",
      },
      backgroundImage: {
        'highlights': "url('/images/backgrounds/highlights.jpg?as=webp')",
        'highlights-mob': "url('/images/backgrounds/highlights-mob.jpg?as=webp')",
        'adv': "url('/images/backgrounds/adv.jpg?as=webp')",
        'adv-mob': "url('/images/backgrounds/adv-mob.jpg?as=webp')",
        'video-poster': "url('/images/backgrounds/video-poster.jpg?as=webp')",
        'video-placeholder': "url('/images/backgrounds/video-placeholder.jpg?as=webp')",
        'values': "url('/images/backgrounds/values.jpg?as=webp')",
        'cta': "url('/images/backgrounds/cta.jpg?as=webp')",
        'light-gradient': "linear-gradient(180deg, rgba(246, 248, 253, 0.00) 0%, #F6F8FD 100%)",
        'light-gradient-top': "linear-gradient(0deg, rgba(246, 248, 253, 0.00) 0%, #EFF3FA 100%)",
        'sky-gradient': "linear-gradient(0deg, rgba(246, 248, 253, 0.00) -42.86%, #EFF3FA 100%)",
        'alaska': "url('/images/backgrounds/alaska.svg')",
        'hawaii': "url('/images/backgrounds/hawaii.svg')",
        'puerto-rico': "url('/images/backgrounds/puerto-rico.svg')",
        'usa': "url('/images/backgrounds/usa.svg')",
        'world': "url('/images/backgrounds/world.svg')",
        'car': "url('/images/backgrounds/car.jpg?as=webp')",
        'exotic': "url('/images/backgrounds/exotic.jpg?as=webp')",
        'truck': "url('/images/backgrounds/truck.jpg?as=webp')",
        'motorcycle': "url('/images/backgrounds/motorcycle.jpg?as=webp')",
        'limo': "url('/images/backgrounds/limo.jpg?as=webp')",
        'rv': "url('/images/backgrounds/rv.jpg?as=webp')",
        'trailer': "url('/images/backgrounds/trailer.jpg?as=webp')",
        'boat': "url('/images/backgrounds/boat.jpg?as=webp')",
        'equipment': "url('/images/backgrounds/equipment.jpg?as=webp')",
        'suv': "url('/images/backgrounds/suv.jpg?as=webp')",
        'van': "url('/images/backgrounds/van.jpg?as=webp')",
        'intro-content': "url('/images/backgrounds/intro-content.jpg?as=webp')",
        'underline': "url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='288' height='6' viewBox='0 0 288 6' fill='none'%3E%3Cpath d='M1 4.38663C83.7194 -1.25603 227.558 1.15668 287.264 4.38663' stroke='%23DB7A43' stroke-width='2'/%3E%3C/svg%3E\")",
        'check': "url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='25' viewBox='0 0 24 25' fill='none'%3E%3Cpath d='M12 2.89844C10.0716 2.89844 8.18657 3.47027 6.58319 4.54161C4.97982 5.61295 3.73013 7.13569 2.99218 8.91727C2.25422 10.6989 2.06114 12.6593 2.43735 14.5506C2.81355 16.4419 3.74215 18.1792 5.10571 19.5427C6.46928 20.9063 8.20656 21.8349 10.0979 22.2111C11.9892 22.5873 13.9496 22.3942 15.7312 21.6563C17.5127 20.9183 19.0355 19.6686 20.1068 18.0652C21.1782 16.4619 21.75 14.5768 21.75 12.6484C21.7473 10.0634 20.7192 7.58505 18.8913 5.75716C17.0634 3.92927 14.585 2.90117 12 2.89844ZM16.2806 10.9291L11.0306 16.1791C10.961 16.2488 10.8783 16.3041 10.7872 16.3419C10.6962 16.3796 10.5986 16.399 10.5 16.399C10.4014 16.399 10.3038 16.3796 10.2128 16.3419C10.1218 16.3041 10.039 16.2488 9.96938 16.1791L7.71938 13.9291C7.57865 13.7883 7.49959 13.5975 7.49959 13.3984C7.49959 13.1994 7.57865 13.0085 7.71938 12.8678C7.86011 12.7271 8.05098 12.648 8.25 12.648C8.44903 12.648 8.6399 12.7271 8.78063 12.8678L10.5 14.5881L15.2194 9.86781C15.2891 9.79813 15.3718 9.74285 15.4628 9.70514C15.5539 9.66743 15.6515 9.64802 15.75 9.64802C15.8486 9.64802 15.9461 9.66743 16.0372 9.70514C16.1282 9.74285 16.2109 9.79813 16.2806 9.86781C16.3503 9.93749 16.4056 10.0202 16.4433 10.1113C16.481 10.2023 16.5004 10.2999 16.5004 10.3984C16.5004 10.497 16.481 10.5946 16.4433 10.6856C16.4056 10.7767 16.3503 10.8594 16.2806 10.9291Z' fill='%23DB7A43'/%3E%3C/svg%3E\")",
       },
      gap: {
        '7.5': '1.875rem',
      },
      height: {
        '75': '300px',
      },
      animation: {
        'phone-wiggle': 'phone-wiggle 0.5s ease-in-out infinite',
      },
      keyframes: {
        'phone-wiggle': {
          '0%, 100%': { transform: 'rotate(0deg)' },
          '25%': { transform: 'rotate(8deg)' },
          '75%': { transform: 'rotate(-8deg)' },
        },
      },
    },
  },
  /* plugins: [
    forms,
  ], */
} satisfies Config;
