# Sage Directives

![Latest Version](https://img.shields.io/packagist/v/log1x/sage-directives.svg?style=flat-square)
![Total Downloads](https://img.shields.io/packagist/dt/log1x/sage-directives.svg?style=flat-square)
![Build Status](https://img.shields.io/github/actions/workflow/status/log1x/sage-directives/main.yml?branch=master&style=flat-square)

Sage Directives adds a variety of useful Blade directives for use with Sage 10 including directives for WordPress, ACF, and various miscellaneous helpers.

## Requirements

- [Sage](https://github.com/roots/sage) >= 10.0
- [PHP](https://secure.php.net/manual/en/install.php) >= 8.1
- [Composer](https://getcomposer.org/download/)

## Installation

Install via Composer:

```bash
$ composer require log1x/sage-directives
```

## Build Documentation

```bash
$ yarn install
$ yarn run docs:build
```

## Support

- [Documentation](https://log1x.github.io/sage-directives-docs/)
- [Discourse](https://discourse.roots.io/t/blade-directives-for-sage/14301)

## Bug Reports

If you discover a bug in Sage Directives, please [open an issue](https://github.com/log1x/sage-directives/issues).

## Contributing

Contributing whether it be through PRs, reporting an issue, or suggesting an idea is encouraged and appreciated. When contributing code, please follow the existing directive format.

I work on Sage Directives entirely in my free time. If Sage Directives has helped you immensely and you would like to support me working on it in the future– feel free to leave a contribution using the :heart: **Sponsor** button above.

## License

Sage Directives is provided under the [MIT License](https://github.com/log1x/sage-directives/blob/master/LICENSE.md).
