<p align="center">
  <a href="https://roots.io/acorn/">
    <img alt="Acorn" src="https://cdn.roots.io/app/uploads/logo-acorn.svg" height="100">
  </a>
</p>

<p align="center">
  <a href="https://packagist.org/packages/roots/acorn">
    <img alt="Packagist Downloads" src="https://img.shields.io/packagist/dt/roots/acorn?label=downloads&colorB=2b3072&colorA=525ddc&style=flat-square">
  </a>

  <a href="https://laravel.com/docs/9.x">
    <img alt="Laravel v9" src="https://img.shields.io/static/v1?label=laravel&message=v9&logo=Laravel&style=flat-square&color=f9322c" />
  </a>

  <a href="https://github.com/roots/acorn/actions/workflows/main.yml">
    <img alt="Build Status" src="https://img.shields.io/github/actions/workflow/status/roots/acorn/main.yml?branch=main&logo=github&label=CI&style=flat-square">
  </a>

  <a href="https://twitter.com/rootswp">
    <img alt="Follow Roots" src="https://img.shields.io/badge/follow%20@rootswp-1da1f2?logo=twitter&logoColor=ffffff&message=&style=flat-square">
  </a>
</p>

<p align="center">Laravel components for WordPress plugins and themes</p>

<p align="center">
  <a href="https://roots.io/acorn/">Website</a> &nbsp;&nbsp; <a href="https://roots.io/acorn/docs/installation/">Documentation</a> &nbsp;&nbsp; <a href="https://github.com/roots/acorn/releases">Releases</a> &nbsp;&nbsp; <a href="https://discourse.roots.io/">Community</a>
</p>

## Sponsors

Acorn is an open source project and completely free to use. If you've benefited from our projects and would like to support our future endeavors, please consider [sponsoring Roots](https://github.com/sponsors/roots).

<div align="center">
<a href="https://k-m.com/"><img src="https://cdn.roots.io/app/uploads/km-digital.svg" alt="KM Digital" width="120" height="90"></a> <a href="https://carrot.com/"><img src="https://cdn.roots.io/app/uploads/carrot.svg" alt="Carrot" width="120" height="90"></a> <a href="https://wordpress.com/"><img src="https://cdn.roots.io/app/uploads/wordpress.svg" alt="WordPress.com" width="120" height="90"></a> <a href="https://pantheon.io/"><img src="https://cdn.roots.io/app/uploads/pantheon.svg" alt="Pantheon" width="120" height="90"></a> <a href="https://worksitesafety.ca/careers/"><img src="https://cdn.roots.io/app/uploads/worksite-safety.svg" alt="Worksite Safety" width="120" height="90"></a> <a href="https://www.copiadigital.com/"><img src="https://cdn.roots.io/app/uploads/copia-digital.svg" alt="Copia Digital" width="120" height="90"></a> 
</div>

## Overview

Acorn is a framework for integrating Laravel within WordPress.

### Supported components

| Component                | Support | Notes |
| ------------------------ | :-----: | ----- |
| illuminate/cache         | 🟢 | |
| illuminate/config        | 🟢 | |
| illuminate/console       | 🟢 | |
| illuminate/container     | 🟢 | |
| illuminate/contracts     | 🟢 | |
| illuminate/database      | 🟢 | |
| illuminate/events        | 🟢 | |
| illuminate/filesystem    | 🟢 | |
| illuminate/http          | 🟢 | |
| illuminate/log           | 🟢 | |
| illuminate/routing       | 🟡 | Requires `ACORN_ENABLE_EXPERIMENTAL_ROUTER` env var |
| illuminate/support       | 🟢 | |
| illuminate/view          | 🟢 | |

<details>
  <summary><b>Additional components</b></summary>
&nbsp;

| Component                | Support | Notes |
| ------------------------ | :-----: | ----- |
| illuminate/auth          | 🔴 | |
| illuminate/broadcasting  | 🔴 | |
| illuminate/bus           | 🔴 | |
| illuminate/collections   | 🔴 | |
| illuminate/conditionable | 🔴 | |
| illuminate/contracts     | 🔴 | |
| illuminate/cookie        | 🔴 | |
| illuminate/encryption    | 🔴 | |
| illuminate/hashing       | 🔴 | |
| illuminate/macroable     | 🔴 | |
| illuminate/mail          | 🔴 | |
| illuminate/notifications | 🔴 | |
| illuminate/pagination    | 🔴 | [Available via Log1x/pagi](https://github.com/Log1x/pagi)
| illuminate/pipeline      | 🔴 | |
| illuminate/queue         | 🔴 | |
| illuminate/redis         | 🔴 | |
| illuminate/session       | 🔴 | |
| illuminate/testing       | 🔴 | |
| illuminate/translation   | 🔴 | |
| illuminate/validation    | 🔴 | |
  
</details>

## Getting Started

See the [Acorn installation documentation](https://roots.io/acorn/docs/installation/).

## Stay Connected

- Join us on Discord by [sponsoring us on GitHub](https://github.com/sponsors/roots)
- Participate on [Roots Discourse](https://discourse.roots.io/)
- Follow [@rootswp on Twitter](https://twitter.com/rootswp)
- Read the [Roots Blog](https://roots.io/blog/)
- Subscribe to the [Roots Newsletter](https://roots.io/newsletter/)

